package kochModel.visitor;

import fp.*;
import kochModel.*;
import java.awt.Graphics;

public class PaintParentVisitor implements IKochVisitor<Object, Graphics> {
  
  public static final PaintParentVisitor Singleton = new PaintParentVisitor();
  
  private PaintParentVisitor() {}
  
  private IFoldAlgo<Koch, Object, Graphics> foldAlgo = new IFoldAlgo<Koch, Object, Graphics>() {
    public Object apply( Koch host, Object base, Graphics... g) {
      return host.execute(PaintParentVisitor.this, g);
    }
  };
  
  public Object baseCase(Koch host, Graphics... g) {
    paint(host, g[0]);
    return null;
  }
  
  public Object inductCase(Koch host, Graphics... g) {
    paint(host, g[0]);
    return host.fold(foldAlgo, null, g);
  }
    
  private void paint(Koch host, Graphics g) {
    g.drawLine((int) Math.round(host.getA().x),(int)Math.round(host.getA().y),
               (int)Math.round(host.getB().x),(int) Math.round(host.getB().y));
    
  }
}